﻿using System;
using System.Windows;

namespace Microscopic_Traffic_Simulator___Model.GeometricObjects.Nodes
{
    /// <summary>
    /// Class representing an object in topology on lane.
    /// </summary>
    [Serializable]
    public abstract class Node
    {
        /// <summary>
        /// Location of node.
        /// </summary>
        private Point location;
        /// <summary>
        /// Location of node.
        /// </summary>        
        public Point Location { get { return location; } }

        /// <summary>
        /// Constructor of node.
        /// </summary>
        /// <param name="location">Location of node.</param>
        internal Node(Point location)
        {
            this.location = location;
        }
    }
}
